import matplotlib.pyplot as plt
from create_graph import color_defaults

# Define the updated colors with ACRO and bVAE switched, and line width for thicker lines
line_width = 3  # Line width for thicker lines
names = ["cask",
        # "caskl",
        "diayn",
        "csd",
        # "rnd",
        "elden",
        "coins",
        "vanilla"
        ]

name_hash = {
        "cask": "SkiLD (ours)",
        "caskl": "SkiLD (ours)",
        "diayn": "DIAYN",
        "csd": "CSD",
        "rnd": "RND",
        "elden": "ELDEN",
        "coins": "COInS",
        "vanilla": "Vanilla"
}
pdf_legend_file_path = './main_ihrl_legend.svg'

# color_defaults = {
#     "cask": '#1f77b4',  # muted blue
#     "caskag": '#d62728',  # brick red
#     "caskad": '#e377c2',  # raspberry yogurt pink
# }


# names = ["cask",
#         "caskag",
#         "caskad",
#         ]

# name_hash = {
#         "cask": "SkiLD (base)",
#         "caskad": "SkiLD w/o Diversity",
#         "caskag": "SkiLD w/o Graphs",
# }
# pdf_legend_file_path = './ablative_legend.svg'




# Creating a figure and a set of subplots
fig, ax = plt.subplots()

# Dummy plot for the legend with updated colors and thicker lines
for n in names:
    ax.plot([], [], label=name_hash[n], color=color_defaults[n], linewidth=line_width)

# Create the legend with a horizontal orientation
legend = ax.legend(frameon = 1, loc='center', ncol=len(names))
frame = legend.get_frame()
frame.set_color('white')

# Hide the axes
ax.axis('off')

# Save the updated figure as a PDF
fig.savefig(pdf_legend_file_path, bbox_inches='tight', format='svg')

# Close the plot to avoid display in the output
plt.close(fig)
